'==========================================================================
'
' NAME: MSDNSProvisioning.vbs
'
'***********************************************************************
' THIS CODE AND INFORMATION IS PROVIDED TO YOU FOR YOUR REFERENTIAL 
' PURPOSES ONLY, AND IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
' EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED 
' WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE, 
' AND MAY NOT BE REDISTRIBUTED IN ANY MANNER.
' 
' Copyright (c) Microsoft Corporation.  All rights reserved.
'***********************************************************************
'
'==========================================================================



Public Function CreateDNSZone(strZoneName,strComputer,strIP)
	Dim oWMI_DNS
	Dim oZone
	'Create an instance of the WMI DNS Service
	Set oWMI_DNS = ConnectDnsService(strComputer)
	'Create an instance of the DNS_Zone service
	Set oZone = oWMI_DNS.Get("MicrosoftDNS_Zone")
	strResult = oZone.CreateZone(strZoneName,0)
	Set oZone=Nothing
	Set oWMI_DNS=Nothing
	
	CreateDNSZone = strResult

End Function

Public Function CreateDnsARecord(strDnsServer,strZoneName,strComputer,strType,strIP)
	Dim oWMI_DNS
	Dim oWKS
	
	'Create an instance of the WMI DNS Service
	Set oWMI_DNS = ConnectDnsService(strComputer)
	'Create an instance of the DNS A type
	Set oWKS = oWMI_DNS.Get("MicrosoftDNS_AType")
	'Create the Record
	strResult = oWKS.CreateInstanceFromPropertyData(strDnsServer,strZoneName,strType & "." & strZoneName,1,600,strIP)
	Set oWMI_DNS = Nothing
	Set oWKS=Nothing
	CreateDnsRecord=strResult

End Function

Public Function CreateDnsMXRecord(strDnsServer,strZoneName,strComputer,strType)
	Dim oWMI_DNS
	Dim oWKS
	
	'Create an instance of the WMI DNS Service
	Set oWMI_DNS = ConnectDnsService(strComputer)
	'Create an instance of the DNS Well Known service (WKS)
	Set oWKS = oWMI_DNS.Get("MicrosoftDNS_MXType")
	'Create the Record
	strResult = oWKS.CreateInstanceFromPropertyData(strDnsServer,strZoneName,"mail." & strZoneName,1,600,1,strType & "." & strZoneName)
	Set oWMI_DNS = Nothing
	Set oWKS=Nothing
	CreateDnsRecord=strResult
End Function

Private Function ConnectDnsService(strComputer)
	Dim oTemp
	
	Set oTemp = GetObject("winmgmts:{impersonationLevel=impersonate}!\\" & strComputer & "\root\MicrosoftDNS")
	Set ConnectDnsService = oTemp
	

End function

